/* JEFScan.c  JEF file scanner */
/* 2009-09-28 Robert Forsyth
 */

#include <stdlib.h>
#include <stdio.h>
#include <math.h>
#include <stdarg.h>
#include <cairo/cairo.h>

#include "JEF.h"

void printinfo(const char *input); 

static void report(const char *fmt, va_list params)
{
	vfprintf(stderr, fmt, params);
}

static void die(const char *fmt, ...)
{
	va_list params;

	va_start(params, fmt);
	report(fmt, params);
	va_end(params);
	exit(1);
}

int
main( int argc, char *argv[])
{
	int i; 
	// double density = 1.0;
    // int outputsize = 128;
	// const char *output = NULL;
	const char *input = NULL;

    if (argc < 2)
       die("usage: %s [-s n] [-d n] file.jef \n", argv[0]);
	for (i = 1; i < argc; i++) 
     {
		const char *arg = argv[i];
		if (*arg == '-') {
			switch (arg[1]) {
			}
			die("Unknown argument '%s'\n", arg);
		}
		if (!input) {
			input = arg;
			continue;
        } 
    } 
	if (!input)
		die("Need a jef input file name\n");

    printinfo(input); 

  return EXIT_SUCCESS;
}

void printinfo(const char *input)
{
    JEF_t *aJEF = JEFNewPath( JEFAlloc(), input);
    
    printf( "JEF file %s\n", input);
    if (aJEF)
    {
      long i;
      long x = 0, y = 0;
      long lft = 0, rgt = 0, top = 0, btm = 0;
      double threadLen = 0.0;
      const JEFHoop_t *aHoop = NULL;
      int threadused[30]; 
      printf( "Header Length: %ld\n", (long) aJEF->stitchesSeek);
      printf( "Flags: %04lx\n", (long) aJEF->flags);
      printf( "Date/time: %s\n", (char*) aJEF->datetime);
      printf( "Thread count: %ld\n", (long) aJEF->threadCount);
      printf( "Stitch count: %ld\n", (long) aJEF->stitchCount);
      aHoop = JEFHoop( aJEF->hoopCode);
      printf( "Hoop: %ld", (long) aJEF->hoopCode);
      if (aHoop)
            printf( " %s %ld %ld", aHoop->hoopType, aHoop->hoopWidth, aHoop->hoopHeight);
      printf( "\n");
      printf( "Rectangle 1: %ld %ld %ld %ld\n", (long) aJEF->left1, (long) aJEF->top1, (long) aJEF->right1, (long) aJEF->bottom1);
      printf( "Rectangle 2: %ld %ld %ld %ld\n", (long) aJEF->left2, (long) aJEF->top2, (long) aJEF->right2, (long) aJEF->bottom2);
      printf( "Rectangle 3: %ld %ld %ld %ld\n", (long) aJEF->left3, (long)      aJEF->top3, (long) aJEF->right3, (long) aJEF->bottom3);
      printf( "Rectangle 4: %ld %ld %ld %ld\n", (long) aJEF->left4, (long) aJEF->top4, (long) aJEF->right4, (long) aJEF->bottom4);
      printf( "Rectangle 5: %ld %ld %ld %ld\n", (long) aJEF->left5, (long) aJEF->top5, (long) aJEF->right5, (long) aJEF->bottom5);
        
      if (aJEF->JEFThreadColours && aJEF->JEFThreadTypes)
//	for (i=0; i<aJEF->threadCount; ++i)
//	{
//	  const JEFColour_t *aJEFColour = JEFColour(aJEF->JEFThreadColours[i]);
//	  //printf( "Thread %ld: Color %02ld type %ld %s %s %s\n", (long)i + 1, (long)aJEF->JEFThreadColours[i], (long)aJEF->JEFThreadTypes[i], aJEFColour->ColourNumber, aJEFColour->RGB, aJEFColour->ColourName);
  //    char rgb[20]; 
    //  int r,g,b; 
    //  sscanf(aJEFColour->RGB,"#%2X%2X%2X",&r,&g,&b); 
	//  printf( "Thread %ld: Color %s, %s (%d,%d,%d)\n", (long)i + 1, aJEFColour->ColourName, aJEFColour->ColourNumber,  r, g, b);
//	}
      if (aJEF->JEFThreadColours && aJEF->JEFThreadTypes && aJEF->JEFStitches)
      {
        int moveWithoutStitch = 0;
	    int reachedEnd = 0;
	    long threadIndex = 0;
	    printf( "Load Thread %ld: %ld %ld\n", (long)threadIndex + 1, (long)aJEF->JEFThreadColours[threadIndex], (long)aJEF->JEFThreadTypes[threadIndex]);
	    for (i=0; i<aJEF->stitchCount; ++i)
	    {
	      JEFStitch_t s = aJEF->JEFStitches[i];
	      if (s.dx == -128)
	      {
	        switch (s.dy)
	        {
              case 1: /* change thread */
                printf( "Thread Used: %.1f\n", threadLen);
              threadused[threadIndex]=(int) (threadLen/100.0); // now in cm, 
		        ++threadIndex;
		        if (threadIndex >= aJEF->threadCount)
		          threadIndex = 0;
		        printf( "Load Thread %ld: %ld %ld\n", (long)threadIndex + 1, (long)aJEF->JEFThreadColours[threadIndex], (long)aJEF->JEFThreadTypes[threadIndex]);
		        threadLen = 0.0;
		      break;
	          case 2: /* move */
		      moveWithoutStitch = 1;
              break;
	          case 16: /* end */
		      reachedEnd = 1;
              threadused[threadIndex]=(int) (threadLen/100.0); // now in cm  
		      printf( "Thread Used: %.1f\n", threadLen);
		      break;
	    }
	  }
	  else
	  {
	    double modLen;
	    x += s.dx;
	    y += s.dy;
	    if (x < lft) lft = x;
	    if (x > rgt) rgt = x;
	    if (y < btm) btm = y;
	    if (y > top) top = y;
	    if (!moveWithoutStitch)
	    {
	      modLen = sqrt( s.dx * s.dx + s.dy * s.dy);
	      threadLen += modLen;
	    }
	    moveWithoutStitch = 0;
	  }
	}
	printf( "Reached end: %s\n", (char*) (reachedEnd ? "Yes" : "No"));
      }

	for (i=0; i<aJEF->threadCount; ++i)
	{
	  const JEFColour_t *aJEFColour = JEFColour(aJEF->JEFThreadColours[i]);
	  //printf( "Thread %ld: Color %02ld type %ld %s %s %s\n", (long)i + 1, (long)aJEF->JEFThreadColours[i], (long)aJEF->JEFThreadTypes[i], aJEFColour->ColourNumber, aJEFColour->RGB, aJEFColour->ColourName);
      int r,g,b; 
      sscanf(aJEFColour->RGB,"#%2X%2X%2X",&r,&g,&b); 
	  printf( "Thread %ld: Color %s, %s (%d,%d,%d) %.2fM used. \n", (long)i + 1, aJEFColour->ColourName, aJEFColour->ColourNumber,  r, g, b, (float) threadused[i]/100.0);

	}
      printf( "Stitch extent: %ld %ld %ld %ld\n", (long) lft, (long)      top, (long) rgt, (long) btm);
      
    }
    
    aJEF = JEFFree( aJEF);
}
