#include "pes.h"
#include <math.h> 
#include <stdio.h>

#define X(stitch) (((stitch)->x - pes->min_x) * scale)
#define Y(stitch) (((stitch)->y - pes->min_y) * scale)

void output_data(struct pes *pes, int size, double density)
{
	int width  = pes->max_x - pes->min_x, outw;
	int height = pes->max_y - pes->min_y, outh;
	double scale = 1.0;
	struct pes_block *block;

	if (size > 0) {
		int maxd = width > height ? width : height;
		scale = (double) size / maxd;
	}
	outw = width * scale;
	outh = height * scale;

	// surface = cairo_image_surface_create (CAIRO_FORMAT_ARGB32, outw+1, outh+1);

	block = pes->blocks;
    double oldx,oldy; 
    oldx=0; oldy=0;
    short int flag=1;  
	while (block) {
		struct color *c = block->color;
		struct stitch *stitch = block->stitch;
		int i;
        double thread_used=0.0; 

		// cairo_set_source_rgb(cr, c->r / 255.0, c->g / 255.0, c->b / 255.0);
	    // cairo_move_to(cr, X(stitch), Y(stitch));

        printf("Thread color %s [%d,%d,%d] ",c->name,c->r,c->g,c->b); 

		for (i = 1; i < block->nr_stitches; i++) {
			++stitch;
			//if(!stitch->jumpstitch) cairo_line_to(cr, X(stitch), Y(stitch));
			//else cairo_move_to(cr, X(stitch), Y(stitch));
			if (flag)
            {
            oldx=stitch->x;
            oldy=stitch->y; 
            flag=0; 
            }               
            thread_used+=sqrt((stitch->x-oldx)*(stitch->x-oldx)+(stitch->y-oldy)*(stitch->y-oldy)); 
            oldx=stitch->x;
            oldy=stitch->y; 
		}
		//cairo_set_line_width(cr, scale * density);
		//cairo_set_line_cap(cr, CAIRO_LINE_CAP_ROUND);
		//cairo_set_line_join(cr, CAIRO_LINE_JOIN_ROUND);
		//cairo_stroke(cr);
		printf("%0.2fM used %d stitches\n",thread_used/10000.0, block->nr_stitches); 

		block = block->next;
	}
        printf("Size %0.1fcm x %0.1fcm (%0.2fi x %0.2fi)\n",outw/100.0,outh/100.0,outw/254.0,outh/254.0);  
// cairo_surface_write_to_png(surface, filename);
}
