/* JEFColour.c - Janome Embroidery Format internal colours */
/* 2009-09-28 Robert Forsyth
   This is a job for an associate array.
 */

#include "JEFColour.h"
#include <stdio.h>
#include <stdlib.h> 
#include <string.h>
// #include <stdlib.h>
//
//  typedef
//  struct JEFColour_s
//  {
//    long JEFThreadColourCode; /* internal JEF code */
//    char *ColourNumber;
//    char *ColourName;
//    char *RGB; /* #RRGGBB value */
//  }
//  JEFColour_t;
//

#define  mwpall 4 // include mark winders colour definitions. Are they right ? 


static JEFColour_t JEFColours[] =
{

#if mwpall == 1 // use the original rather limited pallete 
// code numb name rgb
0x01, "2", "Black", "#000000",
0x02, "1", "White", "#F0F0F0",
0x03, "239", "Sunflower", "#FFCC00",
0x06, "226", "Green", "#237336",
0x07, "232", "Navy Blue", "#071650",
0x09, "201", "Pink", "#F669A0",
0x0a, "202", "Vermilion", "#FF4720",
0x0b, "236", "Cinnamon", "#E2A188",
0x0d, "3", "Gold", "#E4C35D",
0x11, "211", "Pale Pink", "#F999B7",
0x15, "209", "Pale Violet", "#AC9CC7",
0x19, "227", "Pale Aqua", "#98D6BD",
0x1a, "207", "Blue", "#0B2F84",
0x1b, "229", "Powder Blue", "#98F3FE",
0x24, "238", "Blond", "#F5DB8B",
0x2a, "225", "Red", "#FF0000",
0x2c, "246", "Moss Green", "#608541",
0x2f, "249", "Aquamarine", "#5BD2B5",
0x33, "253", "Ivory White", "#FFFFDC",
0x34, "235", "Burnt Orange", "#FF5A27",
0x35, "238", "Blond", "#F5DB8B",
0x47, "273", "Honey Dew", "#FF9D00",
0x48, "274", "Tangerine", "#FFBA5E",
0x4e, "224", "Bamboo", "#E3BE81",
0x1d, "2529", "Dolphin Blue", "#3A75C4", // Rob Ray
0x3c, "5684", "Jay Blue", "#001888", // Rob Poly
0x38, "1385", "Wine", "#612533", // Mad Ray
0x4b, "1250", "Dark Green", "#007047", // Mad Ray
-1, "", "UNDENTIFIED", "#000000",                        // This one returned if not found. 
-1, "203", "Orange", "#FF6600",
-1, "204", "Yellow", "#FFFF17",
-1, "205", "Dark Brown", "#481A05",
-1, "206", "Bright Green", "#00B552",
-1, "208", "Purple", "#AB5A96",
-1, "210", "Pale Yellow", "#FDF5B5",
-1, "212", "Peach", "#FAB381",
-1, "213", "Beige", "#D7BDA4",
-1, "214", "Brown", "#9C6445",
-1, "215", "Wine Red", "#970533",
-1, "216", "Pale Sky", "#A0B8CC",
-1, "217", "Sky", "#65C2C8",
-1, "218", "Yellow Green", "#7FC21C",
-1, "219", "Olive Green", "#2F5933",
-1, "220", "Silver Gray", "#E5E5E5",
-1, "221", "Gray", "#889B9B",
-1, "222", "Ocean Blue", "#0257B5",
-1, "223", "Beige Gray", "#D0BAB0",
-1, "228", "Baby Blue", "#B2E1E3",
-1, "230", "Bright Blue", "#70A9E2",
-1, "231", "Slate Blue", "#1D5478",
-1, "233", "Salmon Pink", "#FFBBBB",
-1, "234", "Coral", "#FF6048",
-1, "237", "Umber", "#B59474",
-1, "240", "Orchid Pink", "#FFBDE3",
-1, "241", "Peony Purple", "#C3007E",
-1, "242", "Burgundy", "#A80043",
-1, "243", "Royal Purple", "#540571",
-1, "244", "Cardinal Red", "#FF0927",
-1, "245", "Opal Green", "#C6EECB",
-1, "247", "Meadow Green", "#609418",
-1, "248", "Dark Green", "#06480D",
-1, "250", "Emerald Green", "#4CB58F",
-1, "251", "Peacock Green", "#04917B",
-1, "252", "Dark Gray", "#595B61",
-1, "254", "Hazel", "#E6651E",
-1, "255", "Toast", "#E6965A",
-1, "256", "Salmon", "#F09C96",
-1, "257", "Cocoa Brown", "#A76C3D",
-1, "258", "Sienna", "#B45A30",
-1, "259", "Sepia", "#6E3937",
-1, "260", "Dark Sepia", "#5C2625",
-1, "261", "Violet Blue", "#6231BD",
-1, "262", "Blue Ink", "#14329C",
-1, "263", "Solar Blue", "#165FA7",
-1, "264", "Green Dust", "#C4E39D",
-1, "265", "Crimson", "#FD33A3",
-1, "266", "Floral Pink", "#EE71AF",
-1, "267", "Wine", "#843154",
-1, "268", "Olive Drab", "#A39166",
-1, "269", "Meadow", "#0C8918",
-1, "270", "Mustard", "#F7F297",
-1, "271", "Yellow Ocher", "#CC9900",
-1, "272", "Old Gold", "#C79732",
-1, "275", "Canary Yellow", "#FCF121",
-1, "", "", ""
#elif mwpall == 2 // use the new pallette 

                                  // inferred from threadchart.info
                                  // This pallette seems more complete but differs in a few overlap values. 
0x01,"J-001","White", "#F0F0F0",
0x02,"J-002","Black", "#000000",
0x03,"J-003","Gold", "#E4C35D",
0x04,"J-201","Pink", "#F669A0",
0x05,"J-225","Red", "#FF0000",
0x06,"J-203","Orange", "#FF6600",
0x07,"J-204","Yellow", "#FFFF17",
0x08,"J-205","Dark Brown", "#481A05",
0x09,"J-226","Green", "#237336",
0x0a,"J-207","Blue", "#0B2F84",
0x0b,"J-208","Purple", "#AB5A96",
0x0c,"J-209","Pale Violet", "#AC9CC7",
0x0d,"J-210","Pale Yellow", "#FDF5B5",
0x0e,"J-211","Pale Pink", "#F999B7",
0x0f,"J-212","Peach", "#FAB381",
0x10,"J-213","Beige", "#D7BDA4",
0x11,"J-214","Brown", "#9C6445",
0x12,"J-215","Wine Red", "#970533",
0x13,"J-216","Pale Sky", "#A0B8CC",
0x14,"J-217","Sky", "#65C2C8",
0x15,"J-218","Yellow Green", "#7FC21C",
0x16,"J-219","Olive Green", "#2F5933",
0x17,"J-220","Silver Gray", "#E5E5E5",
0x18,"J-221","Gray", "#889B9B",
0x19,"J-227","Pale Aqua", "#98D6BD",
0x1a,"J-228","Baby Blue", "#B2E1E3",
0x1b,"J-229","Powder Blue", "#98F3FE",
0x1c,"J-230","Bright Blue", "#70A9E2",
0x1d,"J-231","Slate Blue", "#1D5478",
0x1e,"J-232","Navy Blue", "#071650",
0x1f,"J-233","Salmon Pink", "#FFBBBB",
0x20,"J-234","Coral", "#FF6048",
0x21,"J-235","Burnt Orange", "#FF5A27",
0x22,"J-236","Cinnamon", "#E2A188",
0x23,"J-237","Umber", "#B59474",
0x24,"J-238","Blond", "#F5DB8B",
0x25,"J-239","Sunflower", "#FFCC00",
0x26,"J-240","Orchid Pink", "#FFBDE3",
0x27,"J-241","Peony Purple", "#C3007E",
0x28,"J-242","Burgundy", "#A80043",
0x29,"J-243","Royal Purple", "#540571",
0x2a,"J-244","Cardinal Red", "#FF0927",
0x2b,"J-245","Opal Green", "#C6EECB",
0x2c,"J-246","Moss Green", "#608541",
0x2d,"J-247","Meadow Green", "#609418",
0x2e,"J-248","Dark Green", "#06480D",
0x2f,"J-249","Aquamarine", "#5BD2B5",
0x30,"J-250","Emerald Green", "#4CB58F",
0x31,"J-251","Peacock Green", "#04917B",
0x32,"J-252","Dark Gray", "#595B61",
0x33,"J-253","Ivory White", "#FFFFDC",
0x34,"J-202","Vermilion", "#FF4720",
0x35,"J-206","Bright Green", "#00B552",
0x36,"J-222","Ocean Blue", "#0257B5",
0x37,"J-223","Beige Gray", "#D0BAB0",
0x38,"J-224","Bamboo", "#E3BE81",
0x39,"J-254","Hazel", "#E6651E",
0x3a,"J-255","Toast", "#E6965A",
0x3b,"J-256","Salmon", "#F09C96",
0x3c,"J-257","Cocoa Brown", "#A76C3D",
0x3d,"J-258","Sienna", "#B45A30",
0x3e,"J-259","Sepia", "#6E3937",
0x3f,"J-260","Dark Sepia", "#5C2625",
0x40,"J-261","Violet Blue", "#6231BD",
0x41,"J-262","Blue Ink", "#14329C",
0x42,"J-263","Solar Blue", "#165FA7",
0x43,"J-264","Green Dust", "#C4E39D",
0x44,"J-265","Crimson", "#FD33A3",
0x45,"J-266","Floral Pink", "#EE71AF",
0x46,"J-267","Wine", "#843154",
0x47,"J-268","Olive Drab", "#A39166",
0x48,"J-269","Meadow", "#0C8918",
0x49,"J-270","Mustard", "#F7F297",
0x4a,"J-271","Yellow Ocher", "#CC9900",
0x4b,"J-272","Old Gold", "#C79732",
0x4c,"J-273","Honey Dew", "#FF9D00",
0x4d,"J-274","Tangerine", "#FFBA5E",
0x4e,"J-275","Canary Yellow", "#FCF121",
-1, "", "UNDENTIFIED", "#000000",                        // This one returned if not found. 

#elif mwpall == 3                                        // The new pallette didnt work well in some key places. 
                                                         // this pallete use the original pallete suplemented 
                                                         // with new values where missing from original. 
0x01,"002","Black", "#000000",                           
0x02,"001","White", "#F0F0F0", 
0x03,"239","Sunflower", "#FFCC00", 
0x06,"226","Green", "#237336", 
0x07,"232","Navy Blue", "#071650", 
0x09,"201","Pink", "#F669A0", 
0x0a,"202","Vermilion", "#FF4720", 
0x0b,"236","Cinnamon", "#E2A188", 
0x0d,"003","Gold", "#E4C35D", 
0x11,"211","Pale Pink", "#F999B7", 
0x15,"209","Pale Violet", "#AC9CC7", 
0x19,"227","Pale Aqua", "#98D6BD", 
0x1a,"207","Blue", "#0B2F84", 
0x1b,"229","Powder Blue", "#98F3FE", 
0x1d,"2529","Dolphin Blue", "#3A75C4",  // Rob Ray
0x2a,"225","Red", "#FF0000", 
0x2c,"246","Moss Green", "#608541", 
0x2f,"249","Aquamarine", "#5BD2B5", 
0x33,"253","Ivory White", "#FFFFDC", 
0x34,"235","Burnt Orange", "#FF5A27", 
0x35,"238","Blond", "#F5DB8B", 
0x38,"1385","Wine", "#612533",  // Mad Ray
0x3c,"5684","Jay Blue", "#001888",  // Rob Poly
0x47,"273","Honey Dew", "#FF9D00", 
0x48,"274","Tangerine", "#FFBA5E", 
0x4b,"1250","Dark Green", "#007047",  // Mad Ray
0x4e,"224","Bamboo", "#E3BE81", 
// new values - mw 
0x06,"203","Orange", "#FF6600",
0x07,"204","Yellow", "#FFFF17",
0x08,"205","Dark Brown", "#481A05",
0x0b,"208","Purple", "#AB5A96",
0x0d,"210","Pale Yellow", "#FDF5B5",
0x0f,"212","Peach", "#FAB381",
0x10,"213","Beige", "#D7BDA4",
0x11,"214","Brown", "#9C6445",
0x12,"215","Wine Red", "#970533",
0x13,"216","Pale Sky", "#A0B8CC",
0x14,"217","Sky", "#65C2C8",
0x15,"218","Yellow Green", "#7FC21C",
0x16,"219","Olive Green", "#2F5933",
0x17,"220","Silver Gray", "#E5E5E5",
0x18,"221","Gray", "#889B9B",
0x1a,"228","Baby Blue", "#B2E1E3",
0x1c,"230","Bright Blue", "#70A9E2",
0x1d,"231","Slate Blue", "#1D5478",
0x1f,"233","Salmon Pink", "#FFBBBB",
0x20,"234","Coral", "#FF6048",
0x23,"237","Umber", "#B59474",
0x26,"240","Orchid Pink", "#FFBDE3",
0x27,"241","Peony Purple", "#C3007E",
0x28,"242","Burgundy", "#A80043",
0x29,"243","Royal Purple", "#540571",
0x2a,"244","Cardinal Red", "#FF0927",
0x2b,"245","Opal Green", "#C6EECB",
0x2d,"247","Meadow Green", "#609418",
0x2e,"248","Dark Green", "#06480D",
0x30,"250","Emerald Green", "#4CB58F",
0x31,"251","Peacock Green", "#04917B",
0x32,"252","Dark Gray", "#595B61",
0x35,"206","Bright Green", "#00B552",
0x36,"222","Ocean Blue", "#0257B5",
0x37,"223","Beige Gray", "#D0BAB0",
0x39,"254","Hazel", "#E6651E",
0x3a,"255","Toast", "#E6965A",
0x3b,"256","Salmon", "#F09C96",
0x3c,"257","Cocoa Brown", "#A76C3D",
0x3d,"258","Sienna", "#B45A30",
0x3e,"259","Sepia", "#6E3937",
0x3f,"260","Dark Sepia", "#5C2625",
0x40,"261","Violet Blue", "#6231BD",
0x41,"262","Blue Ink", "#14329C",
0x42,"263","Solar Blue", "#165FA7",
0x43,"264","Green Dust", "#C4E39D",
0x44,"265","Crimson", "#FD33A3",
0x45,"266","Floral Pink", "#EE71AF",
0x46,"267","Wine", "#843154",
0x47,"268","Olive Drab", "#A39166",
0x48,"269","Meadow", "#0C8918",
0x49,"270","Mustard", "#F7F297",
0x4a,"271","Yellow Ocher", "#CC9900",
0x4b,"272","Old Gold", "#C79732",
0x4e,"275","Canary Yellow", "#FCF121",
-1, "", "UNDENTIFIED", "#000000",                        // This one returned if not found. 
//
#elif mwpall == 4                                        // Yet another new pallette, keeping more strictly to Janome! 
0x02,"J-001","White" ,"#F0F0F0"  ,
0x01,"J-002","Black" ,"#000000"                            ,
0x03,"J-003","Gold" ,"#E4C35D"  ,
0x04,"J-201","Pink" ,"#F669A0"  ,
0x05,"J-202","Red" ,"#FF4720"  ,
0x06,"J-203","Orange" ,"#FF6600" ,
0x07,"J-204","Yellow" ,"#FFFF17" ,
0x08,"J-205","Dark Brown" ,"#481A05" ,
0x09,"J-206","Green" ,"#00B552" ,
0x0a,"J-207","Blue" ,"#0B2F84"  ,
0x0b,"J-208","Purple" ,"#AB5A96" ,
0x0c,"J-209","Pale Violet" ,"#AC9CC7"  ,
0x0d,"J-210","Pale Yellow" ,"#FDF5B5" ,
0x0e,"J-211","Pale Pink" ,"#F999B7"  ,
0x0f,"J-212","Peach" ,"#FAB381" ,
0x10,"J-213","Beige" ,"#D7BDA4" ,
0x11,"J-214","Brown" ,"#9C6445" ,
0x12,"J-215","Wine Red" ,"#970533" ,
0x13,"J-216","Pale Sky" ,"#A0B8CC" ,
0x14,"J-217","Sky" ,"#65C2C8" ,
0x15,"J-218","Yellow Green" ,"#7FC21C" ,
0x16,"J-219","Olive Green" ,"#2F5933" ,
0x17,"J-220","Silver Gray" ,"#E5E5E5" ,
0x18,"J-221","Gray" ,"#889B9B" ,
0x19,"J-222","Ocean Blue" ,"#0257B5" ,
0x1a,"J-223","Beige-Gray" ,"#D0BAB0" ,
0x1b,"J-224","Bamboo" ,"#E3BE81"  ,
0x1c,"J-225","Xmas Red" ,"#FF0000"  ,
0x1d,"J-226","Xmas Green" ,"#237336"  ,
0x1e,"J-227","Pale Aqua" ,"#98D6BD"  ,
0x1f,"J-228","Baby Blue" ,"#B2E1E3" ,
0x20,"J-229","Powder Blue" ,"#98F3FE"  ,
0x21,"J-230","Bright Blue" ,"#70A9E2" ,
0x22,"J-231","State Blue" ,"#1D5478" ,
0x23,"J-232","Navy Blue" ,"#071650"  ,
0x24,"J-233","Salmon Pink" ,"#FFBBBB" ,
0x25,"J-234","Coral" ,"#FF6048" ,
0x26,"J-235","Burnt Orange" ,"#FF5A27"  ,
0x27,"J-236","Cinnamon" ,"#E2A188"  ,
0x28,"J-237","Umber" ,"#B59474" ,
0x29,"J-238","Blond" ,"#F5DB8B"  ,
0x2a,"J-239","Sunflower" ,"#FFCC00"  ,
0x2b,"J-240","Orchid Pink" ,"#FFBDE3" ,
0x2c,"J-241","Peony Purple" ,"#C3007E" ,
0x2d,"J-242","Burgundy" ,"#A80043" ,
0x2e,"J-243","Royal Purple" ,"#540571" ,
0x2f,"J-244","Cardinal Red" ,"#FF0927" ,
0x30,"J-245","Opal Green" ,"#C6EECB" ,
0x31,"J-246","Moss Green" ,"#608541"  ,
0x32,"J-247","Meadow Green" ,"#609418" ,
0x33,"J-248","Dark Green" ,"#06480D" ,
0x34,"J-249","Aquamarine" ,"#5BD2B5"  ,
0x35,"J-250","Emerald Green" ,"#4CB58F" ,
0x36,"J-251","Peacock Green" ,"#04917B" ,
0x37,"J-252","Dark Gray" ,"#595B61" ,
0x38,"J-253","Ivory White" ,"#FFFFDC"  ,
0x39,"J-254","Hazel" ,"#E6651E" ,
0x3a,"J-255","Toast" ,"#E6965A" ,
0x3b,"J-256","Salmon" ,"#F09C96" ,
0x3c,"J-257","Cocoa Brown" ,"#A76C3D" ,
0x3d,"J-258","Sienna" ,"#B45A30" ,
0x3e,"J-259","Sepia" ,"#6E3937" ,
0x3f,"J-260","Dark Sepia" ,"#5C2625" ,
0x40,"J-261","Violet Blue" ,"#6231BD" ,
0x41,"J-262","Blue Ink" ,"#14329C" ,
0x42,"J-263","Soda Blue" ,"#165FA7" ,
0x43,"J-264","Green Dust" ,"#C4E39D" ,
0x44,"J-265","Crimson" ,"#FD33A3" ,
0x45,"J-266","Floral Pink" ,"#EE71AF" ,
0x46,"J-267","Wine" ,"#843154" ,
0x47,"J-268","Olive Drab" ,"#A39166" ,
0x48,"J-269","Meadow" ,"#0C8918" ,
0x49,"J-270","Mustard" ,"#F7F297" ,
0x4a,"J-271","Yellow Ocher" ,"#CC9900" ,
0x4b,"J-272","Old Gold" ,"#C79732" ,
0x4c,"J-273","Honeydew" ,"#FF9D00"  ,
0x4d,"J-274","Tangerine" ,"#FFBA5E"  ,
0x4e,"J-275","Canary Yellow" ,"#FCF121" ,
-1, "J-", "UNDENTIFIED", "#000000",                        // This one returned if not found. 
#endif 

};


// does a linear search from the start for a particular key value. 
// This is SLOW!! But thats ok. 
// If found, returns the index into the colour table. 
// if NOT, returns -1. 
//
int colourtablesearch(long aColourCode)
{
  int i = 0;
  while (JEFColours[i].JEFThreadColourCode != aColourCode)
  {
    if (JEFColours[i].JEFThreadColourCode == -1)
    { 
      // printf("Colour with code %ld (%lx) not identified\n",aColourCode,aColourCode); 
      return -1; 
    } 
    ++i;
  }
  // printf("Colour with code %ld (%lx) identified\n",aColourCode,aColourCode); 
  return i;
}

// The action here is a bit enhanced from the original. 
// If we find the requested thread code, we use it. 
// If not we seaach in ever widening area around for one with a similar code
// Does this work. No not very well. 
// But it does mean that its likely that we get a slightly close color that is radically different from 
// other colours in designs using a small number of colours. 
// Its completely useless for large numbers of colours. :-( 
// But then you better get an accurate pallete in that case!!
// The approximaion has the suffex 'Guessed from ... ' appeneded to it. 
// A small amount of malloced memory is leaked each time this happens. Bah! 
// So if this appears contorted, it is. The JEF format refers to colours using a 
// colour code, and we dont know what all these are! 

#define dbg 1
const JEFColour_t *JEFColour( long aColourCode) /* find the colour of the code */
{
  int i = -1;
  long acc=aColourCode; 
  long sacc=acc; // what we started with so in the case of a guess we can report 
  int j=0; 
  while (1)
  {
    i=colourtablesearch(acc+j); 
    if (i!=-1)
    {
         acc=acc+j; 
         break; 
    } 
    if (acc-j>0 && j!=0) i=colourtablesearch(acc-j); 
    if (i!=-1)
    {
         acc=acc-j; 
         break; 
    } 
    j++; 
  }  
  if (j!=0) // means not found, so we guessed the nearest code
            // it could be anything, but if we do not know, we would like 
            // at least that its similar and different to other colours in the 
            // picture. 
   { 
      JEFColour_t *c; 
      c=(JEFColour_t *) malloc(sizeof(JEFColour_t)); 
      *c=JEFColours[i]; 
      char *p=malloc(50); 
      *p=(char) 0; 
      strcat(p,c->ColourName); 
      char q[20]; 
      sprintf(q," (Guessed from 0x%02lx)",sacc); 
      strcat(p,q); 
      c->ColourName=p; 
      return c;  
   } 
  return JEFColours + i;
}

// This is the original function more or less, not now used. 
const JEFColour_t *xJEFColour( long aColourCode) /* find the colour of the code */
{
  int i = 0;
  while (JEFColours[i].JEFThreadColourCode != aColourCode)
  {
    if (JEFColours[i].JEFThreadColourCode == -1)
    { 
      // printf("Colour with code %ld (%lx) not identified\n",aColourCode,aColourCode); 
      
      return JEFColours + i;
      // break;
    } 
    ++i;
  }
  // printf("Colour with code %ld (%lx) identified\n",aColourCode,aColourCode); 
  return JEFColours + i;
}
