#ifndef JEF_H
#define JEF_H
/* JEF.h - Janome Embroidery Format */
/* 2009-09-28 Robert Forsyth
 */

#include <stdlib.h>
#include <fcntl.h>

#include "JEFColour.h"

typedef long JEFThreadColour_t;
typedef long JEFThreadType_t;
typedef
  struct JEFStitch_s
  {
    signed char dx, dy;
  }
JEFStitch_t;

typedef
  struct JEFHoop_s
  {
    long JEFHoopCode;
    char *hoopType;
    long hoopWidth, hoopHeight; /* 0.1mm */
  }
JEFHoop_t;

typedef
  struct JEF_s
  {
    long stitchesSeek; /* length of header and threadCount lists*/
    long flags; /* 1 implies date */
    char datetime[16];
    long threadCount;
    long stitchCount;
    long hoopCode;
    long left1; /* in 0.1mm */
    long top1; /* in 0.1mm */
    long right1; /* in 0.1mm */
    long bottom1; /* in 0.1mm */
    long left2; /* in 0.1mm */
    long top2; /* in 0.1mm */
    long right2; /* in 0.1mm */
    long bottom2; /* in 0.1mm */
    long left3;
    long top3;
    long right3;
    long bottom3;
    long left4;
    long top4;
    long right4;
    long bottom4;
    long left5; /* in 0.1mm */
    long top5; /* in 0.1mm */
    long right5; /* in 0.1mm */
    long bottom5; /* in 0.1mm */
    JEFThreadColour_t *JEFThreadColours;
    JEFThreadType_t *JEFThreadTypes;
    JEFStitch_t *JEFStitches;
  }
JEF_t;

JEF_t *JEFAlloc(); /* return an empty JEF object or NULL */
JEF_t *JEFFree( JEF_t *aJEF); /* return NULL after freeing JEF object */

JEF_t *JEFNew( JEF_t *aJEF); /* initialise a JEF object - it is safe to do aJEF = JEFNew(JEFAlloc()) */
JEF_t *JEFNewPath( JEF_t *aJEF, const char *path); /* initialise a JEF object from file */
JEF_t *JEFNewFD( JEF_t *aJEF, int fd); /* initialise a JEF object from file descriptor */
const JEFHoop_t *JEFHoop(long aHoopCode); /* Hoop from code */

#endif
